#!/bin/bash

stty iutf8  # Ensure UTF-8 support for the script execution

SCRIPT_PATH="$( cd -- "$(dirname "$0")" >/dev/null 2>&1 ; pwd -P )"
source "${SCRIPT_PATH}/_common.sh"

LOG_FILE="${LOG_DIR}/installer_$(date +"%Y%m%d_%H%M").log"

main() {
    local rdi_cli_dir_name; rdi_cli_dir_name=$(get_rdi_cli_dir) || exit 1
    local redis_di_path="${SCRIPT_PATH}/deps/rdi-cli/${rdi_cli_dir_name}/redis-di"

    setup_binary "${redis_di_path}"
    setup_logs
    setup_sudo_env

    # Create initial context file for installation
    if [ -n "${SUDO_USER}" ]; then
        echo "[]" > ${HOME}/.redis-di
        chown ${SUDO_USER}:$(id -gn ${SUDO_USER}) ${HOME}/.redis-di
    fi

    redis-di install "$@" 2>&1 | tee "${LOG_FILE}"
}

check_root
main "$@"
