#!/bin/bash

stty iutf8  # Ensure UTF-8 support for the script execution

SCRIPT_PATH="$( cd -- "$(dirname "$0")" >/dev/null 2>&1 ; pwd -P )"
source "${SCRIPT_PATH}/_common.sh"

LOG_FILE="${LOG_DIR}/upgrade_$(date +"%Y%m%d_%H%M").log"

check_context_file() {
    local context_file="${HOME}/.redis-di"
    if [ ! -f "${context_file}" ]; then
        echo "WARNING: Redis-di context file not found at: ${context_file}"
    fi
}

main() {
    local rdi_cli_dir_name; rdi_cli_dir_name=$(get_rdi_cli_dir) || exit 1
    local redis_di_path="${SCRIPT_PATH}/deps/rdi-cli/${rdi_cli_dir_name}/redis-di"

    setup_binary "${redis_di_path}"
    setup_logs
    setup_sudo_env
    check_context_file

    redis-di upgrade "$@" 2>&1 | tee "${LOG_FILE}"
}

check_root
main "$@"
