# Redis Data Integration 1.6.6 GA

> This release replaces the 1.6.5 release.

RDI's mission is to help Redis customers sync Redis Enterprise with live data from their slow disk-based databases to:

- Meet the required speed and scale of read queries and provide an excellent and predictable user experience.
- Save resources and time when building pipelines and coding data transformations.
- Reduce the total cost of ownership by saving money on expensive database read replicas.

RDI keeps the Redis cache up to date with changes in the primary database, using a [_Change Data Capture (CDC)_](https://en.wikipedia.org/wiki/Change_data_capture) mechanism.
It also lets you _transform_ the data from relational tables into convenient and fast data structures that match your app's requirements. You specify the transformations using a configuration system, so no coding is required.

## Headlines

- Reintroduced the `/strategies` endpoint to provide a list of databases, ensuring compatibility with RedisInsight.
- Added a new Helm script to facilitate the creation of the source SSL secrets.
- Enhanced the RDI API `/login` endpoint to accept both **user** and **username** parameters.
- Updated the behavior of the `/schemas` endpoint to return a list of databases for MySQL and MariaDB, replacing the previous behavior of returning an empty list of schemas.

## New Features and Improvements

## Limitations

RDI can write data to a Redis Active-Active database. However, it doesn't support writing data to two or more Active-Active replicas. Writing data from RDI to several Active-Active replicas could easily harm data integrity as RDI is not synchronous with the source database commits.
