#!/bin/bash

stty iutf8  # Ensure UTF-8 support for the script execution

SCRIPT_PATH="$( cd -- "$(dirname "$0")" >/dev/null 2>&1 ; pwd -P )"
source "${SCRIPT_PATH}/_common.sh"

LOG_FILE="${LOG_DIR}/k3s_uninstall_$(date +"%Y%m%d_%H%M%S").log"

main() {
    if [ ! -f "${K3S_UNINSTALL_SCRIPT}" ]; then
        die "RDI is not installed."
    fi

    check_user_confirmation "This will uninstall RDI and its dependencies, are you sure?"

    ${K3S_UNINSTALL_SCRIPT} > "${LOG_FILE}" 2>&1
    uninstall_exit_code=$?

    if [ ${uninstall_exit_code} -ne 0 ]; then
        die "RDI uninstall has failed. Log available at: ${LOG_FILE}"
    fi

    setup_sudo_env

    # Cleanup RDI files
    rm -f "${HOME}/.redis-di"
    rm -f /usr/local/bin/redis-di
    rm -f /usr/bin/redis-di

    echo "RDI uninstalled successfully."
}

check_root
main
